/*
Java Comparator example.
This Java Comparator example describes how java.util.Comparator
interface is implemented to compare Java custom class objects.

This Java Comparator is passed to Collection's sorting method
(for example Collections.sort method) to perform sorting of Java custom class objects.
 */

package utilisation;

import java.util.*;
import entreprise.Employee;
import entreprise.Agenda;
import comparator.ComparatorEntreprise;

/*
This Java comparator example compares employees on the basis of
their age and name and sort them in that order.
 */

public class JavaComparatorExample{

	public static void main(String args[]){

		Employee employees[] = new Employee[2];

		employees[0] = new Employee(40, "Joe", 2000);
		employees[1] = new Employee(20, "Mark", 1400);

		System.out.println("Order of employees before sorting is");
		for(int i=0; i < employees.length; i++){
			System.out.println( "Employee " + (i+1)  + " salaire :: " + employees[i].getSalaire() 
					+ " name :: " + employees[i].getName() 
					+ ", Age :: " + employees[i].getAge());
		}

		Arrays.sort(employees);
		System.out.println("\n\nOrder of employee after sorting by employee salaire is");
		for(int i=0; i < employees.length; i++){
			System.out.println( "Employee " + (i+1)+ " salaire :: " + employees[i].getSalaire()
					+ " name :: " + employees[i].getName() 
					+ ", Age :: " + employees[i].getAge());
		}


		Arrays.sort(employees, ComparatorEntreprise.AGE_ORDER);

		System.out.println("\n\nOrder of employee after sorting by employee age is");
		for(int i=0; i < employees.length; i++){
			System.out.println( "Employee " + (i+1) + " salaire :: " + employees[i].getSalaire()
					+ " name :: " + employees[i].getName() 
					+ ", Age :: " + employees[i].getAge());
		}


		Arrays.sort(employees, ComparatorEntreprise.NAME_ORDER);

		System.out.println("\n\nOrder of employees after sorting by employee name is");    
		for(int i=0; i < employees.length; i++){
			System.out.println( "Employee " + (i+1) + " salaire :: " + employees[i].getSalaire() 
					+ " name :: " + employees[i].getName() 
					+ ", Age :: " + employees[i].getAge());
		}


		Agenda agendas[] = new Agenda[2];
		agendas[0] = new Agenda(employees[0]);
		agendas[1] = new Agenda(employees[1]);

		Arrays.sort(agendas, ComparatorEntreprise.EMPLOYEE_SALAIRE_ORDER);

		System.out.println("\n\nOrder of agendas after sorting by their employee salaire is");    
		for(int i=0; i < agendas.length; i++){
			System.out.println( "Agenda " + (i+1) + " employe :: " + agendas[i].getEmploye());
		}

	}
}
